USE [{DBName}]

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT

BEGIN TRANSACTION

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'{DBOwner}[PK_qi_OrganizationPaymentMethods]') AND type = N'PK')
	ALTER TABLE {DBOwner}[qi_OrganizationPaymentMethods] DROP CONSTRAINT [PK_qi_OrganizationPaymentMethods] WITH ( ONLINE = OFF )

ALTER TABLE {DBOwner}[qi_OrganizationPaymentMethods] ADD CONSTRAINT [PK_qi_OrganizationPaymentMethods] PRIMARY KEY CLUSTERED
(
	[OrganizationIC] ASC,
	[OrganizationU] ASC,
	[PaymentMethodIC] ASC,
	[PaymentMethodU] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'{DBOwner}[PK_qi_OrganizationShipmentMethods]') AND type = N'PK')
	ALTER TABLE {DBOwner}[qi_OrganizationShipmentMethods] DROP CONSTRAINT [PK_qi_OrganizationShipmentMethods] WITH ( ONLINE = OFF )

ALTER TABLE {DBOwner}[qi_OrganizationShipmentMethods] ADD CONSTRAINT [PK_qi_OrganizationShipmentMethods] PRIMARY KEY CLUSTERED
(
	[OrganizationIC] ASC,
	[OrganizationU] ASC,
	[ShipmentMethodIC] ASC,
	[ShipmentMethodU] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


GO
COMMIT